**************************************************************************************************
*******************LOCAL INCOME INEQUALITY AND HOUSEHOLD INDEBTEDNESS ****************************
*************************REGRESSION ANALYSIS *****************************************************
*************************DATE: JAN 2022 **********************************************************
*************************AUTHOR: KIM NGUYEN ******************************************************
**************************************************************************************************

clear all
set more off
set maxvar 30000
set matsize 10000

//Load data
use "UnbalancedHH_analytical.dta", clear

//Global vars
global DemCovar "age age2 sex Luni Lkids Ladults Lmarried Lemp Lnilf Lselfemp Duni Dkids Dadults Dmarried Demp Dnilf Dselfemp"
global FinCovar "Lginc Dginc Lassets Dassets Lfinassets Dfinassets Lliqnworth Dliqnworth"
global MacroCovar "Lmedhp Dmedhp Lurate Durate Lmedinc Dmedinc Lmeddebt Dmeddebt"

//TABLE 2: Effects of a one standard deviation increase in Gini coefficient

*Total debt
eststo m1: quietly xtreg Ddebttoinc dgini $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0 & L.selfemp==0,  vce(cluster hhssa3)
*Mortgage debt
eststo m2: quietly xtreg Dmortgagedebttoinc dgini $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0 & L.selfemp==0,  vce(cluster hhssa3)
*Home debt
eststo m3: quietly xtreg Dhomedebttoinc dgini $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0 & L.selfemp==0,  vce(cluster hhssa3)
*Other property debt
eststo m4: quietly xtreg Dopropdebttoinc dgini $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0 & L.selfemp==0,  vce(cluster hhssa3)
*Non-ortgage debt
eststo m5: quietly xtreg Dnmdebttoinc dgini $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0 & L.selfemp==0,  vce(cluster hhssa3)
*Credit card debt
eststo m6: quietly xtreg Dccdebttoinc dgini $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0 & L.selfemp==0,  vce(cluster hhssa3)
*Hire-purchase debt
eststo m7: quietly xtreg Dhiredebttoinc dgini $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0 & L.selfemp==0,  vce(cluster hhssa3)
*Car debt
eststo m8: quietly xtreg Dcardebttoinc dgini $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0 & L.selfemp==0,  vce(cluster hhssa3)
*Business debt
eststo m9: quietly xtreg Dbusdebttoinc dgini $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0 & L.selfemp==0,  vce(cluster hhssa3)
*Investment debt
eststo m10: quietly xtreg Dinvdebttoinc dgini $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0 & L.selfemp==0,  vce(cluster hhssa3)

*save table
esttab m1 m2 m3 m4 m5 m6 m7 m8 m9 m10 using "Tables\Table D2 - Effects of Change in Gini - NSE.csv",  b(2) se(2) keep(*dgini*) margin title(Debt regressions) star(* 0.10 ** 0.05 *** 0.01) replace nogaps

